import { world, system, ItemStack, BlockPermutation } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:copper_chain', {
        onTick(data) {
            const { block, player } = data
            const blockState = block.permutation.getState("minecraft:block_face");
            if (blockState) {
                const chain = BlockPermutation.resolve('v360:exposed_copper_chain_block', { "minecraft:block_face": blockState });
                block.setPermutation(chain);
            }
        },
        onPlayerInteract(data) {
            const { block, player } = data
            const blockState = block.permutation.getState("minecraft:block_face");
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            if (blockState && selectedItem?.typeId === 'minecraft:honeycomb') {
                const chain = BlockPermutation.resolve('v360:waxed_copper_chain_block', { "minecraft:block_face": blockState });
                const { x, y, z } = block.location
                block.setPermutation(chain);
                block.dimension.runCommand(`particle v360:wax ${x} ${y + 0.5} ${z}`)
                block.dimension.playSound("copper.wax.on", block.location)
                if (player.getGameMode() !== "creative") {
                    player.runCommandAsync('clear @s minecraft:honeycomb 0 1')
                }
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:exposed_copper_chain', {
        onTick(data) {
            const { block, player } = data
            const blockState = block.permutation.getState("minecraft:block_face");
            if (blockState) {
                const chain = BlockPermutation.resolve('v360:weathered_copper_chain_block', { "minecraft:block_face": blockState });
                block.setPermutation(chain);
            }
        },
        onPlayerInteract(data) {
            const { block, player } = data
            const blockState = block.permutation.getState("minecraft:block_face");
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            if (blockState && selectedItem?.typeId === 'minecraft:honeycomb') {
                const chain = BlockPermutation.resolve('v360:waxed_exposed_copper_chain_block', { "minecraft:block_face": blockState });
                const { x, y, z } = block.location
                block.setPermutation(chain);
                block.dimension.runCommand(`particle v360:wax ${x} ${y + 0.5} ${z}`)
                block.dimension.playSound("copper.wax.on", block.location)
                if (player.getGameMode() !== "creative") {
                    player.runCommandAsync('clear @s minecraft:honeycomb 0 1')
                }
            }
            else if (blockState && selectedItem?.hasTag('minecraft:is_axe')) {
                const chain = BlockPermutation.resolve('v360:copper_chain_block', { "minecraft:block_face": blockState });
                const { x, y, z } = block.location
                block.setPermutation(chain);
                block.dimension.runCommand(`particle v360:oxidization_off ${x} ${y + 0.5} ${z}`)
                block.dimension.playSound("copper.wax.off", block.location)
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:weathered_copper_chain', {
        onTick(data) {
            const { block, player } = data
            const blockState = block.permutation.getState("minecraft:block_face");
            if (blockState) {
                const chain = BlockPermutation.resolve('v360:oxidized_copper_chain_block', { "minecraft:block_face": blockState });
                block.setPermutation(chain);
            }
        },
        onPlayerInteract(data) {
            const { block, player } = data
            const blockState = block.permutation.getState("minecraft:block_face");
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            if (blockState && selectedItem?.typeId === 'minecraft:honeycomb') {
                const chain = BlockPermutation.resolve('v360:waxed_weathered_copper_chain_block', { "minecraft:block_face": blockState });
                const { x, y, z } = block.location
                block.setPermutation(chain);
                block.dimension.runCommand(`particle v360:wax ${x} ${y + 0.5} ${z}`)
                block.dimension.playSound("copper.wax.on", block.location)
                if (player.getGameMode() !== "creative") {
                    player.runCommandAsync('clear @s minecraft:honeycomb 0 1')
                }
            }
            else if (blockState && selectedItem?.hasTag('minecraft:is_axe')) {
                const chain = BlockPermutation.resolve('v360:exposed_copper_chain_block', { "minecraft:block_face": blockState });
                const { x, y, z } = block.location
                block.setPermutation(chain);
                block.dimension.runCommand(`particle v360:oxidization_off ${x} ${y + 0.5} ${z}`)
                block.dimension.playSound("copper.wax.off", block.location)
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:oxidized_copper_chain', {
        onPlayerInteract(data) {
            const { block, player } = data
            const blockState = block.permutation.getState("minecraft:block_face");
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            if (blockState && selectedItem?.typeId === 'minecraft:honeycomb') {
                const chain = BlockPermutation.resolve('v360:waxed_oxidized_copper_chain_block', { "minecraft:block_face": blockState });
                const { x, y, z } = block.location
                block.setPermutation(chain);
                block.dimension.runCommand(`particle v360:wax ${x} ${y + 0.5} ${z}`)
                block.dimension.playSound("copper.wax.on", block.location)
                if (player.getGameMode() !== "creative") {
                    player.runCommandAsync('clear @s minecraft:honeycomb 0 1')
                }
            }
            else if (blockState && selectedItem?.hasTag('minecraft:is_axe')) {
                const chain = BlockPermutation.resolve('v360:weathered_copper_chain_block', { "minecraft:block_face": blockState });
                const { x, y, z } = block.location
                block.setPermutation(chain);
                block.dimension.runCommand(`particle v360:oxidization_off ${x} ${y + 0.5} ${z}`)
                block.dimension.playSound("copper.wax.off", block.location)
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:waxed_copper_chain', {
        onPlayerInteract(data) {
            const { block, player } = data
            const blockState = block.permutation.getState("minecraft:block_face");
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            if (blockState && selectedItem?.hasTag('minecraft:is_axe')) {
                const chain = BlockPermutation.resolve('v360:copper_chain_block', { "minecraft:block_face": blockState });
                const { x, y, z } = block.location
                block.setPermutation(chain);
                block.dimension.runCommand(`particle v360:wax_off ${x} ${y + 0.5} ${z}`)
                block.dimension.playSound("copper.wax.off", block.location)
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:waxed_exposed_copper_chain', {
        onPlayerInteract(data) {
            const { block, player } = data
            const blockState = block.permutation.getState("minecraft:block_face");
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            if (blockState && selectedItem?.hasTag('minecraft:is_axe')) {
                const chain = BlockPermutation.resolve('v360:exposed_copper_chain_block', { "minecraft:block_face": blockState });
                const { x, y, z } = block.location
                block.setPermutation(chain);
                block.dimension.runCommand(`particle v360:wax_off ${x} ${y + 0.5} ${z}`)
                block.dimension.playSound("copper.wax.off", block.location)
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:waxed_weathered_copper_chain', {
        onPlayerInteract(data) {
            const { block, player } = data
            const blockState = block.permutation.getState("minecraft:block_face");
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            if (blockState && selectedItem?.hasTag('minecraft:is_axe')) {
                const chain = BlockPermutation.resolve('v360:weathered_copper_chain_block', { "minecraft:block_face": blockState });
                const { x, y, z } = block.location
                block.setPermutation(chain);
                block.dimension.runCommand(`particle v360:wax_off ${x} ${y + 0.5} ${z}`)
                block.dimension.playSound("copper.wax.off", block.location)
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:waxed_oxidized_copper_chain', {
        onPlayerInteract(data) {
            const { block, player } = data
            const blockState = block.permutation.getState("minecraft:block_face");
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            if (blockState && selectedItem?.hasTag('minecraft:is_axe')) {
                const chain = BlockPermutation.resolve('v360:oxidized_copper_chain_block', { "minecraft:block_face": blockState });
                const { x, y, z } = block.location
                block.setPermutation(chain);
                block.dimension.runCommand(`particle v360:wax_off ${x} ${y + 0.5} ${z}`)
                block.dimension.playSound("copper.wax.off", block.location)
            }
        }
    })
})